/**************************************************************************
**                                                                        *
**  FILE        :  _cmulg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex multiplication.                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>


/*
 * _cmul(x,y)
 *
 * z = (x.r*y.i - x.i*y.i) + i(x.r*y.i + x.i*y.r)
 */
extern  double complex          _d_cmul(double complex x, double complex y)
{
        double complex z;
        __cd_r(z) = __cd_r(x) * __cd_r(y) - __cd_i(x) * __cd_i(y);
        __cd_i(z) = __cd_r(x) * __cd_i(y) + __cd_i(x) * __cd_r(y);
        return z;
}
