/**************************************************************************
**                                                                        *
**  FILE        :  _cdivg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex division.                                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include <math.h>
#include <complex.h>

/*
 * _cdiv(x,y)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */
extern  long double complex             _ld_cdiv(long double complex x, long double complex y)
{
        long double complex z;
        long double r,den;
        if (fabsl(__cld_r(y)) >= fabsl(__cld_i(y)))
        {
                r = __cld_i(y)/__cld_r(y);
                den = __cld_r(y) + r*__cld_i(y);
                __cld_r(z) = (__cld_r(x) + r*__cld_i(x))/den;
                __cld_i(z) = (__cld_i(x) - r*__cld_r(x))/den;
        }
        else
        {
                r = __cld_r(y)/__cld_i(y);
                den = __cld_i(y) + r*__cld_r(y);
                __cld_r(z) = (__cld_r(x)*r + __cld_i(x))/den;
                __cld_i(z) = (__cld_i(x)*r - __cld_r(x))/den;
        }
        return z;
}
