/**************************************************************************
**                                                                        *
**  FILE        :  _cdivg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex division.                                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include <math.h>
#include <complex.h>

/*
 * _cdiv(x,y)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */
extern  float complex           _f_cdiv(float complex x, float complex y)
{
        float complex z;
        float r,den;
        if (fabsf(__cf_r(y)) >= fabsf(__cf_i(y)))
        {
                r = __cf_i(y)/__cf_r(y);
                den = __cf_r(y) + r*__cf_i(y);
                __cf_r(z) = (__cf_r(x) + r*__cf_i(x))/den;
                __cf_i(z) = (__cf_i(x) - r*__cf_r(x))/den;
        }
        else
        {
                r = __cf_r(y)/__cf_i(y);
                den = __cf_i(y) + r*__cf_r(y);
                __cf_r(z) = (__cf_r(x)*r + __cf_i(x))/den;
                __cf_i(z) = (__cf_i(x)*r - __cf_r(x))/den;
        }
        return z;
}
