/**************************************************************************
**                                                                        *
**  FILE        :  _cdivg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex division.                                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include <math.h>
#include <complex.h>

/*
 * _cdiv(x,y)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */
extern  double complex          _d_cdiv(double complex x, double complex y)
{
        double complex z;
        double r,den;
        if (fabs(__cd_r(y)) >= fabs(__cd_i(y)))
        {
                r = __cd_i(y)/__cd_r(y);
                den = __cd_r(y) + r*__cd_i(y);
                __cd_r(z) = (__cd_r(x) + r*__cd_i(x))/den;
                __cd_i(z) = (__cd_i(x) - r*__cd_r(x))/den;
        }
        else
        {
                r = __cd_r(y)/__cd_i(y);
                den = __cd_i(y) + r*__cd_r(y);
                __cd_r(z) = (__cd_r(x)*r + __cd_i(x))/den;
                __cd_i(z) = (__cd_i(x)*r - __cd_r(x))/den;
        }
        return z;
}
