/**************************************************************************
**
**  FILE        :  exception.c
**
**  DESCRIPTION :  Functions that implement the "bad_exception" class
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#include "basics.h"
#include "runtime.h"

/* The definition of the exception classes can be disabled. */
#ifdef __USE_TASKING_EXCEPTION_CLASSES

#if EXCEPTION_HANDLING

#include __TASKING_CXX_NATIVE_HEADER(exception)

__TASKING_START_NAMESPACE

exception::exception() THROW_NOTHING()
/*
Constructor for exception.
*/
{
}  /* exception::exception */


exception::exception(const exception&) THROW_NOTHING()
/*
Copy constructor for exception.
*/
{
}  /* exception::exception */


exception& exception::operator=(const exception&) THROW_NOTHING()
/*
Assignment operator for exception.  Currently does nothing.
*/
{
  return *this;
}  /* exception::operator= */


exception::~exception() THROW_NOTHING()
/*
Destructor for exception.
*/
{
}  /* exception::~exception */


const char* exception::what() const THROW_NOTHING()
/*
Return a string providing information about the exception.  Currently,
no additional information is available.
*/
{
  return "";
}  /* exception::~exception */


bad_exception::bad_exception() THROW_NOTHING()
/*
Constructor for bad_exception.
*/
{
}  /* bad_exception::bad_exception */


bad_exception::bad_exception(const bad_exception& rhs)
THROW_NOTHING() : exception(rhs)
/*
Copy constructor for bad_exception.  Currently does nothing.
*/
{
}  /* bad_exception::bad_exception */


bad_exception& bad_exception::operator=(const bad_exception& rhs)
THROW_NOTHING()
/*
Assignment operator for bad_exception.  Currently does nothing.
*/
{
  /* Call the base class assignment operator. */
  exception::operator=(rhs);
  return *this;
}  /* bad_exception::operator= */


bad_exception::~bad_exception() THROW_NOTHING()
/*
Destructor for bad_exception.
*/
{
}  /* bad_exception::~bad_exception */


const char* bad_exception::what() const THROW_NOTHING()
/*
Return a string providing information about the exception.  Currently,
no additional information is available.
*/
{
  return "";
}  /* bad_exception::what */

__TASKING_END_NAMESPACE

#endif /* EXCEPTION_HANDLING */

#endif /* defined(__USE_TASKING_EXCEPTION_CLASSES) */
