/**************************************************************************
**
**  FILE        :  error.c
**
**  DESCRIPTION :  error handling
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#ifndef ERROR_H
#define ERROR_H 1

typedef enum /* an_error_code */ {
  ec_none,
  ec_abort_header,
  ec_terminate_called,
  ec_terminate_returned,
  ec_already_marked_for_destruction,
  ec_main_called_more_than_once,  /* No longer used. */
  ec_pure_virtual_called,
  ec_bad_cast,
  ec_bad_typeid,
  ec_array_not_from_vec_new,
  ec_terminate_called_more_than_once,
  ec_negative_vla_size,
  ec_vla_allocation_failed,
  ec_last
} an_error_code;

EXTERN_C void __abort_execution(an_error_code err_code);

#endif /* ERROR_H */
