/**************************************************************************
**
**  FILE        :  bad_alloc.c
**
**  DESCRIPTION :  Member functions of the bad_cast class
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#include "basics.h"
#include "runtime.h"

/* The definition of the exception classes can be disabled. */
#ifdef __USE_TASKING_EXCEPTION_CLASSES

__TASKING_START_NAMESPACE

#if EXCEPTION_HANDLING

/*
The bad_alloc class is only supplied when the runtime supports exception
handling.
*/

bad_alloc::bad_alloc() THROW_NOTHING()
/*
Constructor for bad_alloc.
*/
{
}  /* bad_alloc::bad_alloc */


bad_alloc::bad_alloc(const bad_alloc& rhs) THROW_NOTHING() : exception(rhs)
/*
Copy constructor for bad_alloc.  Currently does nothing.
*/
{
}  /* bad_alloc::bad_alloc */


bad_alloc& bad_alloc::operator=(const bad_alloc& rhs) THROW_NOTHING()
/*
Assignment operator for bad_alloc.  Currently does nothing.
*/
{
  /* Call the base class assignment operator. */
  exception::operator=(rhs);
  return *this;
}  /* bad_alloc::operator= */


bad_alloc::~bad_alloc() THROW_NOTHING()
/*
Destructor for bad_alloc.
*/
{
}  /* bad_alloc::~bad_alloc */


const char* bad_alloc::what() const THROW_NOTHING()
/*
Return a string providing information about the exception.  Currently,
no additional information is available.
*/
{
  return "";
}  /* bad_alloc::~bad_alloc */

#endif /* EXCEPTION_HANDLING */

__TASKING_END_NAMESPACE

#endif /* defined(__USE_TASKING_EXCEPTION_CLASSES) */
