/**************************************************************************
**
**  FILE        :  array_nonew.c
**
**  DESCRIPTION :  No-throw version of C++ operator new[]()
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#include "basics.h"
#include "runtime.h"

#if ABI_CHANGES_FOR_ARRAY_NEW_AND_DELETE

void *operator new[](STD_NAMESPACE::size_t           size,
                     const STD_NAMESPACE::nothrow_t& nothrow_arg)
THROW_NOTHING()
/*
Nothrow version of array operator new.  Just call the normal nothrow
operator new.
*/
{
  return operator new(size, nothrow_arg);
}  /* operator new[] */

#endif /* ABI_CHANGES_FOR_ARRAY_NEW_AND_DELETE */
