/**************************************************************************
**
**  FILE        :  array_new.c
**
**  DESCRIPTION :  C++ operator new[]()
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#include "basics.h"
#include "runtime.h"

#if ABI_CHANGES_FOR_ARRAY_NEW_AND_DELETE

void *operator new[](STD_NAMESPACE::size_t size) THROW(STD_NAMESPACE::bad_alloc)
/*
Default array operator new.  Just call the normal operator new.
*/
{
  return operator new(size);
}  /* operator new[] */

#endif /* ABI_CHANGES_FOR_ARRAY_NEW_AND_DELETE */
