////////////////////////////////////////////////////////////////////////////
//
//  File        :  mb.lsl
//
//  Version     :  @(#)mb.lsl   1.26    09/04/10
//
//  Description :  Linker script file for the MicroBlaze architecture
//
//  Copyright 2003-2003 Altium BV
//

// set default stack size
#ifndef __STACK
#  define __STACK               32k
#endif
// set default heap size
#ifndef __HEAP
#  define __HEAP                32k
#endif

#define BOUNDS_GROUP_NAME       bounds
#define BOUNDS_GROUP_SELECT     "bounds"

#define SDA_GROUP_NAME          anchor_r13
#define SDA_GROUP_SELECT        "(.sdata*|.sbss*)"


architecture MB
{
        endianness
        {
                big;
        }
        space   main 
        {
                id        = 1;
                mau       = 8;
                align     = 4;
                map
                (
                        size        = 4G,
                        dest        = bus:addr_bus
                );

                copytable
                (
                        align     = 4,
                        copy_unit = 4
                );
                stack "stack"
                (
                        min_size = __STACK,
#ifdef __STACK_FIXED
                        fixed,
#endif
                        align    = 4,
                        grows    = high_to_low
                );
                heap "heap"
                (
                        min_size = __HEAP, 
#ifdef __HEAP_FIXED
                        fixed,
#endif
                        align    = 4
                );

                start_address
                (
#ifdef __START
                        run_addr = __START,
#endif
                        symbol = "_START"
                );

                section_layout
                {
#ifdef __HEAPADDR
                        group ( ordered, run_addr=__HEAPADDR )
                        {
                                select "heap";
                        }
#endif
#ifdef __STACKADDR
                        group ( ordered, run_addr=__STACKADDR )
                        {
                                select "stack";
                        }
#endif
                        // define labels for bounds begin and end as used in C library
#ifndef BOUNDS_GROUP_REDEFINED
                        group BOUNDS_GROUP_NAME (ordered, contiguous)
                        {
                                select BOUNDS_GROUP_SELECT;
                        }
#endif
                        "_lc_ub_bounds" := addressof(group:BOUNDS_GROUP_NAME);
                        "_lc_ue_bounds" := addressof(group:BOUNDS_GROUP_NAME) + sizeof(group:BOUNDS_GROUP_NAME);

#ifndef SDA_GROUP_REDEFINED
                        group SDA_GROUP_NAME ( contiguous, align = 4, page_size=64k )
                        {
                                select SDA_GROUP_SELECT;
                        }
#endif
                        "_base_r13"     := addressof(group:SDA_GROUP_NAME) + 0x8000;
                }
        }

        bus addr_bus
        {
                mau   = 8;
                width = 32;
        }
}

////////////////////////////////////////////////////////////////////////////
//
// If no memory is defined yet use the following memory settings
//
#ifndef __MEMORY

#ifndef __IROMSTART
#  define __IROMSTART   0
#endif
#ifndef __IROMSIZE
#  define __IROMSIZE    64k
#endif
#ifndef __IRAMSTART
#  define __IRAMSTART   (__IROMSTART + __IROMSIZE)
#endif
#ifndef __IRAMSIZE
#  define __IRAMSIZE    512k
#endif
#ifndef __XROMSTART
#  define __XROMSTART   (__IRAMSTART + __IRAMSIZE)
#endif
#ifndef __XROMSIZE
#  define __XROMSIZE    512k
#endif

memory irom
{
        mau  = 8;
        type = rom;
        size = __IROMSIZE;
        map ( size = __IROMSIZE, dest_offset = __IROMSTART, dest = bus:MB:addr_bus );
}

memory iram
{
    mau = 8;
    type = ram;
    size = __IRAMSIZE;
    map ( size = __IRAMSIZE, dest_offset = __IRAMSTART, dest = bus:MB:addr_bus );
}

memory xrom
{
    mau = 8;
    type = rom;
    size = __XROMSIZE;
    map ( size = __XROMSIZE, dest_offset = __XROMSTART, dest = bus:MB:addr_bus );
}

#endif  // #ifndef __MEMORY

