/**************************************************************************
**                                                                        *
**  FILE        :  wmemcmp.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wmemcmp routine.                       *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

/*
 * Compare the first n wide characters of the object pointed to by s1 to
 * the first n wide characters of the object pointed to by s2.
 *
 * Return > 0 if the wide character string s1  > wide character string s2.
 * Return < 0 if the wide character string s1  < wide character string s2.
 * Return   0 if the wide character string s1 == wide character string s2.
 */
int
wmemcmp( const wchar_t* restrict s1, const wchar_t* restrict s2, size_t n )
{
        for ( ; n > 0; n--, s1++, s2++ )
        {
                if ( *s1 < *s2 )
                {
                        return -1;
                }
                if ( *s1 > *s2 )
                {
                        return +1;
                }
        }

        return 0;
}
