/**************************************************************************
**                                                                        *
**  FILE        :  wctob.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for wctob routine.                         *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <limits.h>
#include <stdio.h>
#include <wchar.h>

/*
 * Determine whether c corresponds to a member of the extended character
 * set whose multibyte character representation is a single byte when in
 * the initial shift state.
 * 
 * Return EOF if c does not correspond to a multibyte character with length
 * one in the initial shift state. Otherwise, return the single-byte
 * representation of that character.
 */
int
wctob( wint_t c )
{
        if ( c > (wint_t) UCHAR_MAX )
        {
                return EOF;
        }

        return (int) c;
}
