/**************************************************************************
**                                                                        *
**  FILE        :  wcscpy.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcscpy routine.                        *
**                 Copies s2 to s1.                                       *
**                 Returns s1.                                            *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

wchar_t *wcscpy(wchar_t * restrict s1, const wchar_t * restrict s2)
{
        wchar_t* os1    = s1;

        while ( (*os1++ = *s2++) )
        {
                /* No action */
                ;
        }

        return s1;
}

