/**************************************************************************
**                                                                        *
**  FILE        :  vwprintf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for vwprintf() routine.                    *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int vwprintf( const wchar_t * restrict format, va_list arg )
{
        int             chars;
        struct _io      io;

        io.fp = stdout;
        chars = _dowprint( &io, format, arg );
        return (ferror(stdout) ? EOF : chars);
}

#endif
