/**************************************************************************
**                                                                        *
**  FILE        :  sscanf.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for sscanf() routine.                      *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <io.h>

int sscanf( const char * restrict s, const char * restrict format, ... )
{
        va_list         ap;
        int             items;
        struct _io      buf;

        va_start( ap, format );
        buf.fp = NULL;
        buf.ptr = (char *) s;
        buf.end = (char *)(s + strlen( s ));
        items = _doscan( & buf, format, ap );
        va_end( ap );
        return items;
}
