/**************************************************************************
**                                                                        *
**  FILE        :  snprintf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for snprintf() routine.                    *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <io.h>

#pragma weak    _doprint

int snprintf( char * restrict s, size_t n, const char * restrict format, ... )
{
        va_list         ap;
        int             chars;
        struct _io      buf;

        chars = 0;
        if (n)
        {
                va_start( ap, format );
                buf.fp = NULL;
                buf.ptr = s;
                buf.end = s + n - 1;
                chars = _doprint( & buf, format, ap );
                va_end( ap );
                *buf.ptr = 0;
        }
        return chars;
}
