/**************************************************************************
**                                                                        *
**  FILE        :  setjmp.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for setjmp function                        *
**                 The setjmp function saves its calling environment in   *
**                 its jmp_buf for later use by the longjmp function.     *
**                 If the return is from a direct invocation, the setjmp  *
**                 function returns zero. If the return is from a call to *
**                 the longjmp, the setjmp function returns a nonzero     *
**                 value.                                                 *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include        <setjmp.h>

int setjmp( jmp_buf env )
{
        
        /*
         *      env[0]=sp;
         */
        __asm( "ex      DE,HL" );
        __asm( "ld      HL,#0" );
        __asm( "add     HL,SP" );
        __asm( "ex      DE,HL" );
        __asm( "ld      [HL],E" );
        __asm( "inc     HL" );
        __asm( "ld      [HL],D" );

        /*
         *      env[0]=return address;
         */
        __asm( "pop     DE" );
        __asm( "inc     HL" );
        __asm( "ld      [HL],E" );
        __asm( "inc     HL" );
        __asm( "ld      [HL],D" );
        __asm( "push    DE" );

        return 0;
}
