/**************************************************************************
**                                                                        *
**  FILE        :  setbuf.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for setbuf() routine                       *
**                 Adds a buffer to the given stream                      *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>

/*
 * Identical to setvbuf(fp, buf, buf ? _IOFBF : _IONBF, BUFSIZ);
 * except that setvbuf():
 * -    drags in malloc() and family.
 * -    has error checking/can return an error.
 */
void setbuf(FILE * restrict fp, char * restrict buf)
{
        _iob_flag_t     flag;

        flag = fp->_flag;
        if (flag & _IOMYBUF)
        {
                free(fp->_base);
        }
        flag &= ~(_IOMYBUF | _IOBUF);
        fp->_base = buf;
        fp->_ptr = buf;
        if (buf)
        {
                flag |= _IOFBF;
                fp->_bufsiz = BUFSIZ;
        }
        else
        {
                flag |= _IONBF;
                fp->_bufsiz = EOF;              /* no ungetc() yet */
        }
        fp->_flag = flag;
        /* fp->_cnt is still zero after fopen()/freopen() */
}
