/**************************************************************************
**                                                                        *
**  FILE        :  scalblnf.c                                             *
**                                                                        *
**  DESCRIPTION :  The scalblnf() function.                               *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>

/*****************************************************************************
|*
|* FUNCTION     : scalblnf
|*
|* DESCRIPTION  :
|*
|*     Same as scalbnf, except that second parameter is long.
|*
*/
#ifdef  __SINGLE_FP__
#pragma alias   scalbln         = _scalbln_spf
#pragma alias   scalblnl        = _scalbln_spf
#endif
#pragma alias   scalblnf        = _scalbln_spf
static
float   _scalbln_spf( float v, int pwr )
{
        float2long_t    u;
        unsigned long   l;
        long            exponent;

        /* double type mapped to float type by compiler */
        u.f     = v;
        l       = u.l;

        exponent        = GET_FLOAT_EXPONENT( l );
        exponent        += pwr;
        l               = STRIP_FLOAT_EXPONENT( l );
        l               = PUT_FLOAT_EXPONENT( l, exponent );

        u.l     = l;
        return u.f;
}
