/**************************************************************************
**                                                                        *
**  FILE        :  raise.c                                                *
**                                                                        *
**  DESCRIPTION :  Executes signal handler sig.                           *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

signalfunction *signaltable[_NSIG];

int (raise)(int signal)
{
        signalfunction *s;
        char *signame;
        
        if (signal <= 0 || _NSIG <= signal)
        {
                return -1;      /* not a legal signal */
        }
        s = signaltable[signal];
        if ( s  != SIG_IGN && s != SIG_DFL )
        {
                signaltable[signal] = SIG_DFL;  /* remove signal handler */
                (*s)(signal);                   /* call signal handler */
        }
        else if (s == SIG_DFL)
        {
                switch (signal)
                {
                case SIGINT:
                        signame = "Signal SIGINT";
                        break;
                case SIGILL:
                        signame = "Signal SIGILL";
                        break;
                case SIGFPE:
                        signame = "Signal SIGFPE";
                        break;
                case SIGSEGV:
                        signame = "Signal SIGSEGV";
                        break;
                case SIGTERM:
                        signame = "Signal SIGTERM";
                        break;
                case SIGABRT:
                        signame = "Signal SIGABRT";
                        break;
                default:
                        signame = "Unexpected signal";
                }
                fputs(signame, stderr);
                fputs(" raised - PROGRAM EXECUTION TERMINATED\n", stderr);
                exit(EXIT_FAILURE);
        }
        return 0;
}
