/**************************************************************************
**                                                                        *
**  FILE        :  memcmp.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for memcmp() routine                       *
**                 Compares memory contents.                              *
**                 Returns : < 0  -- s1<s2                                *
**                           = 0  -- s1=s2                                *
**                           > 0  -- s1>s2                                *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>

int
memcmp( register const void * cs, register const void * ct, size_t n )
{
        unsigned char c1, c2;
        while ( n-- )
        {
                c1 = *(unsigned char *)cs;
                c2 = *(unsigned char *)ct;
                if ( c1 != c2 )
                        return( (int)c1 - (int)c2 );
                cs = (char *)cs + 1;
                ct = (char *)ct + 1;
        }
        return( 0 );
}
