/**************************************************************************
**                                                                        *
**  FILE        :  longjmp.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for longjmp function                       *
**                 The longjmp function restores the environment saved by *
**                 the most recent invocation of the program, with the    *
**                 corresponding jmp_buf argument. The longjmp function   *
**                 cause setjmp to return "val". The                      *
**                 longjmp function cannot cause setjmp to return the     *
**                 value 0. If "val" is 0, then setjmp returns 1.         *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include        <setjmp.h>

void longjmp( jmp_buf env, int val )
{
        /*
         *      SP = env[0];
         */
        __asm("ld       B,D");
        __asm("ld       C,E");
        __asm("ld       E,[HL]");
        __asm("inc      HL");
        __asm("ld       D,[HL]");
        __asm("ex       DE,HL");
        __asm("ld       SP,HL");
        __asm("ex       DE,HL");
        
        /*
         *      return address = env[0];
         */
        __asm("inc      HL");
        __asm("ld       E,[HL]");
        __asm("inc      HL");
        __asm("ld       D,[HL]");
        __asm("ex       DE,HL");
        __asm("ex       [SP],HL");
        
        /* if ( val )
         *      return( val );
         * else
         *      return( 1 );
         */
        __asm("ld       DE,#1");
        __asm("ld       A,C");
        __asm("or       B");
        __asm("gjp      Z, end");
        __asm("ld       D,B");
        __asm("ld       E,C");
        __asm("end:");
}
