/**************************************************************************
**                                                                        *
**  FILE        :  isnan.c                                                *
**                                                                        *
**  DESCRIPTION :  The isnan() function.                                  *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>

/*****************************************************************************
|*
|* FUNCTION     : isnan
|*
|* PARAMETERS   :
|*
|*      double type variable to test
|*
|* RETURN VALUE :
|*
|*      zero if the variable is not NaN, else non-zero
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Test the given variable on being a NaN (IEEE-754) value.
|*
*/
#ifndef __SINGLE_FP__
#pragma alias   _isnan          = _isnan_dpf
#pragma alias   _isnanl         = _isnan_dpf
static
int     _isnan_dpf( double d )
{
#if _IEEE_754_FORMAT
        double2longs_t  u;
        unsigned long   hi;
        unsigned long   lo;

        /* double type acts as double */
        u.d     = d;
        hi      = u.s.hi;
        lo      = u.s.lo;

        return GET_DOUBLE_EXPONENT( hi ) == DOUBLE_BIASED_NaN_EXP &&
                ( GET_DOUBLE_HI_MANTISSA( hi ) || GET_DOUBLE_LO_MANTISSA( lo ) );
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
#endif
