/**************************************************************************
**                                                                        *
**  FILE        :  isfinf.c                                               *
**                                                                        *
**  DESCRIPTION :  The isfinitef() function.                              *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>

/*****************************************************************************
|*
|* FUNCTION     : isfinitef
|*
|* PARAMETERS   :
|*
|*      float type variable to test
|*
|* RETURN VALUE :
|*
|*      zero if the variable is not finite, else non-zero
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Test the given variable on being a finite (IEEE-754) value.
|*
*/
#ifdef  __SINGLE_FP__
#pragma alias   _isfinite               = _isfinite_spf
#pragma alias   _isfinitel              = _isfinite_spf
#endif
#pragma alias   _isfinitef              = _isfinite_spf
static
int     _isfinite_spf( float f )
{
#if _IEEE_754_FORMAT
        float2long_t    u;
        unsigned long   l;

        u.f     = f;
        l       = u.l;

        return GET_FLOAT_EXPONENT( l ) <= MAX_FLOAT_BIASED_EXP;
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
