/**************************************************************************
**                                                                        *
**  FILE        :  init.c
**                                                                        *
**  VERSION     :  1.1
**                                                                        *
**  DESCRIPTION :                                                         *
**                                                                        *
**      Initialize and clear C varaibles.                                 *
**                                                                        *
**      Copy table syntax format:                                         *
**              mode            1 bytes                                   *
**                              0:      stop                              *
**                              1:      copy                              *
**                              2:      clear bss                         *
**              dst addr        2 bytes                                   *
**              src addr        2 bytes                                   *
**              data length     2 bytes                                   *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <string.h>

typedef struct 
{
        unsigned char   mode;
        unsigned char * dst;
        unsigned char * src;
        unsigned int    length;
} LC_CP;

enum
{
        stop,
        copy,
        clear
};

extern LC_CP const _lc_cp[];                    /* start label copy table */

void _init( void )
{
        for ( int i = 0; _lc_cp[i].mode != stop; i++ )
        {
                if ( _lc_cp[i].mode == copy )
                {
                        memcpy( _lc_cp[i].dst, _lc_cp[i].src, _lc_cp[i].length );
                }
                else if ( _lc_cp[i].mode == clear )
                {
                        memset( _lc_cp[i].dst, 0, _lc_cp[i].length );
                }
        }
}
