/**************************************************************************
**                                                                        *
**  FILE        :  hypot.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for hypot() routine                        *
**                 Computes the 'hypotenuse' for the given values         *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#if 0


/*
 * hypot(x,y)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */ 
static
long double
_hypot_qpf( long double x, long double y )
{
        long double ans,temp;
        x = fabsl(x);
        y = fabsl(y);
        if (x == 0.0l)
        {
                ans = y;
        }
        else if (y == 0.0l)
        {
                ans = x;
        }
        else if (x > y)
        {
                temp = y/x;
                ans = x*sqrtl(1.0l+temp*temp);
        }
        else
        {
                temp = x/y;
                ans = y*sqrtl(1.0l+temp*temp);
        }
        return ans;
}

#endif

