/**************************************************************************
**                                                                        *
**  FILE        :  hypot.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for hypot() routine                        *
**                 Computes the 'hypotenuse' for the given values         *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifndef __SINGLE_FP__
#pragma alias   hypotl  = _hypot_dpf
#pragma alias   hypot           = _hypot_dpf


/*
 * hypot(x,y)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */ 
static
double
_hypot_dpf( double x, double y )
{
        double ans,temp;
        x = fabs(x);
        y = fabs(y);
        if (x == 0.0)
        {
                ans = y;
        }
        else if (y == 0.0)
        {
                ans = x;
        }
        else if (x > y)
        {
                temp = y/x;
                ans = x*sqrt(1.0+temp*temp);
        }
        else
        {
                temp = x/y;
                ans = y*sqrt(1.0+temp*temp);
        }
        return ans;
}

#endif

