/**************************************************************************
**                                                                        *
**  FILE        :  fss_stat.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for stat() routine.                        *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to stat() a file on the host platform.             *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fss.h>

#ifndef FSS_MINIMAL
int     stat ( const char * name, struct stat * buf )
{
        FSS_BUF* b = & _fss_buffer;
        size_t  len;    
        int     retval;

        len = strlen( name );
        if      ( len >= FSS_MAXBUF )
        {
                errno = ENAMETOOLONG;
                return -1;
        }
        b->buff_size = offsetof(FSS_BUF,u2) + len + 1;
        b->u1.call_id = FSS_STAT;
        strcpy( b->u2.stat.name, name );
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        else
        {
                buf->st_dev   = (unsigned short) b->u2.stat.out.st_dev;
                buf->st_mode  = (unsigned short) b->u2.stat.out.st_mode;
                buf->st_nlink = (unsigned short) b->u2.stat.out.st_nlink;
                buf->st_size  = b->u2.stat.out.st_size;
                buf->st_atime = b->u2.stat.out.st_atime;
                buf->st_mtime = b->u2.stat.out.st_mtime;
                buf->st_ctime = b->u2.stat.out.st_ctime;
        }
        return retval;
}
#endif
