/**************************************************************************
**                                                                        *
**  FILE        :  fss_rename.c                                           *
**                                                                        *
**  DESCRIPTION :  Source file for rename() routine.                      *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to rename a file on the host platform.             *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fss.h>

int     rename ( const char * old, const char * new )
{
        FSS_BUF* b = & _fss_buffer;
        int     retval;

        b->buff_size = (int)offsetof(FSS_BUF,u2) + (int)sizeof(b->u2.rename);
        b->u1.call_id = FSS_RENAME;
        b->u2.rename.old = (char*) old;
        b->u2.rename.oldlen = (int)strlen( old );
        b->u2.rename.new = (char*) new;
        b->u2.rename.newlen = (int)strlen( new );
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
