/**************************************************************************
**                                                                        *
**  FILE        :  fss_chdir.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for chdir() routine.                       *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to change the current directory on the host.       *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fss.h>

#ifndef FSS_MINIMAL
int     chdir ( const char * path )
{
        FSS_BUF* b = & _fss_buffer;
        size_t  len;    
        int     retval;

        len = strlen( path );
        if      ( len >= FSS_MAXBUF )
        {
                errno = ENAMETOOLONG;
                return -1;
        }
        b->buff_size = offsetof(FSS_BUF,u2) + len + 1;
        b->u1.call_id = FSS_CHDIR;
        strcpy( b->u2.chdir.name, path );
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
#endif
