/**************************************************************************
**                                                                        *
**  FILE        :  fss_access.c                                           *
**                                                                        *
**  DESCRIPTION :  Source file for access() routine.                      *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to check the permissions of a file on the host.    *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fss.h>

#ifndef FSS_MINIMAL
int     access ( const char * name, int mode )
{
        FSS_BUF* b = & _fss_buffer;
        size_t  len;    
        int     retval;

        len = strlen( name );
        if      ( len >= FSS_MAXBUF )
        {
                errno = ENAMETOOLONG;
                return -1;
        }
        b->buff_size = offsetof(FSS_BUF,u2) + sizeof(int) + len + 1;
        b->u1.call_id = FSS_ACCESS;
        b->u2.access.mode = mode;
        strcpy( b->u2.access.name, name );
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
#endif
