/**************************************************************************
**                                                                        *
**  FILE        :  fss__write.c                                           *
**                                                                        *
**  DESCRIPTION :  Source file for _write() routine.                      *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to write a sequence of characters to a file.       *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <fss.h>

#pragma weak _write
#pragma alias _write = _host_write

int     _host_write ( _fd_t fd, const void *buffer, size_t count )
{
        FSS_BUF* b = & _fss_buffer;
        int     retval;

        _fss_init( fd, 0 );
#ifndef FSS_MINIMAL
        if      ( count <= FSS_MAXBUF )
        {
                b->buff_size = (int)offsetof(FSS_BUF,u2) + (int)sizeof(int) + count;
                b->u1.call_id = FSS_WRITE_SHORT;
                b->u2.write_short.fd = fd;
                memcpy( b->u2.write_short.buffer, buffer, count );
        }
        else
#endif
        {
                b->buff_size = (int)offsetof(FSS_BUF,u2) + (int)sizeof(b->u2.write_long);
                b->u1.call_id = FSS_WRITE_LONG;
                b->u2.write_long.fd = fd;
                b->u2.write_long.count = (int)count;
                b->u2.write_long.buffer = buffer;
        }
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
