/**************************************************************************
**                                                                        *
**  FILE        :  fss__unlink.c                                          *
**                                                                        *
**  DESCRIPTION :  Source file for _unlink() routine.                     *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to remove a file on the host platform.             *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <fss.h>

int     _unlink ( const char * name )
{
        FSS_BUF* b = & _fss_buffer;
        int     len;    
        int     retval;

        len = (int)strlen( name );
        if      ( len >= FSS_MAXBUF )
        {
                errno = ENAMETOOLONG;
                return -1;
        }
        b->buff_size = (int)offsetof(FSS_BUF,u2) + len + 1;
        b->u1.call_id = FSS_UNLINK;
        strcpy( b->u2.unlink.name, name );
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
