/**************************************************************************
**                                                                        *
**  FILE        :  fss__open.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for _open() routine.                       *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to open a file on the host platform.               *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <fss.h>

#pragma weak _open
#pragma alias _open = _host_open

_err_t  _host_open ( const char * name, _open_flags_t flags )
{
        FSS_BUF* b = & _fss_buffer;
        int     len;    
        _err_t  retval;

        _fss_init( 0, 0 ); /* _fss_init (0,0) is called here to open streams 0,1,2. This is done *here* because
                            * standard behaviour is that these files are already open. The best place to do
                            * this would be in cstart, but it would be inefficient to include fileIO in all
                            * programs. That's why opening stdin stdout and stderr is done here.
                            */
        len = (int)strlen( name );
        if      ( len >= FSS_MAXBUF )
        {
                errno = ENAMETOOLONG;
                return -1;
        }
        b->buff_size = (int)offsetof(FSS_BUF,u2) + (int)sizeof(int) + len + 1;
        b->u1.call_id = FSS_OPEN;
        b->u2.open.flags = flags;
        strcpy( b->u2.open.name, name );
        _fss_break();           /* pass control to CrossView */
        retval = (_err_t)b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
