/**************************************************************************
**                                                                        *
**  FILE        :  fss__close.c                                           *
**                                                                        *
**  DESCRIPTION :  Source file for _close() routine.                      *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to close a file on the host platform.              *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <fss.h>

#pragma weak _close
#pragma alias _close = _host_close

_err_t  _host_close ( _fd_t fd )
{
        FSS_BUF* b = & _fss_buffer;
        _err_t  retval;

        _fss_init( fd, 1 );
        b->buff_size = (int)offsetof(FSS_BUF,u2) + (int)sizeof(int);
        b->u1.call_id = FSS_CLOSE;
        b->u2.close.fd = fd;
        _fss_break();           /* pass control to CrossView */
        retval = (_err_t)b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
