/**************************************************************************
**                                                                        *
**  FILE        :  fmod.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for fmod() routine                         *
**                 Returns the floating point remainder of the division   *
**                 of x by y, zero if y is zero or if x/y would overflow. *
**                 0 <= | remainder |<| y | and sign remainder is sign x. *
**                                                                        *
** NOTE: This implementation is for IEEE754 doubles, hence -0.0 support.  *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <math.h>
#include <float.h>

#if 0


static
long double
_fmod_qpf( long double x, long double y )
{
        long double n;

        if( y == 0.0l )
                return( 0.0l );

        if( (y < 0.0l ? -y : y) < (x < 0.0l ? -x : x) )
                return( y * modfl( x / y, &n) );
        else
                if( (y < 0.0l ? -y : y) > (x < 0.0l ? -x : x) )
                        return( x );
                else
                {
                        /* IEEE754: if x is negative, the remainder is negative -> copy the sign */
                        return copysignl( 0.0l, x );
                }
}

#endif

