/**************************************************************************
**                                                                        *
**  FILE        :  fgetws.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for fgetws routine.                        *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

wchar_t *fgetws(wchar_t * restrict s, int n, FILE * restrict stream)
{
        wint_t wc = WEOF;
        wchar_t *pts;

        for (pts = s, n--; n > 0; pts++, n--)
        {
                wc = fgetwc(stream);

                if (wc == WEOF)
                {
                        break;
                }

                *pts = (wchar_t) wc;

                if (wc == (wint_t) '\n')
                {
                        break;
                }
        }
        if ( (wc == WEOF) && (pts == s) )
        {
                return NULL;
        }
        /* Append the terminating null wide character.
         */
        *pts = (wchar_t) 0;

        return s;
}

