/**************************************************************************
**                                                                        *
**  FILE        :  fclose.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for fclose() routine                       *
**                 Flushes the buffer for given stream, then closes the   *
**                 stream.                                                *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

/*
 * The function fclose() is called (indirectly) from exit() for every
 * application. To prevent linking in malloc/free and the allocation of
 * the heap for every application, the following function pointer is
 * used to deallocate an I/O buffer. This function pointer is assigned
 * whenever an I/O buffer is allocated by malloc().
 */
void    (*_ptr_to_free)(void *);

int fclose(FILE *fp)
{
        int     ret;

        ret = _fflush(fp);                      /* flush unwritten data, don't care about undoing read */
        if (fp->_flag & _IOMYBUF)               /* Only free() when we did the malloc() */
        {
                _ptr_to_free(fp->_base);
        }
        if (_close(fileno(fp)) < 0)
        {
                ret = EOF;
        }

        /*
         * Free the _iob[] element by clearing _flag. We don't care about the other members.
         */
        fp->_flag = 0;
        return ret;
}
