/**************************************************************************
**                                                                        *
**  FILE        :  fabs.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for fabs() routine                         *
**                 Returns the absolute value of the given 'double'       *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>

#ifndef __SINGLE_FP__
#pragma alias   fabsl   = _fabs_dpf
#pragma alias   fabs            = _fabs_dpf


static
double
_fabs_dpf( double arg )
{
        return copysign( arg, 1.0 );
}

#endif

