/**************************************************************************
**                                                                        *
**  FILE        :  cstart.c
**                                                                        *
**  VERSION     :  1.9
**                                                                        *
**  DESCRIPTION :                                                         *
**                                                                        *
**      The system startup code initializes the system Stack Pointer (SP) *
**      and the application C variables.                                  *
**                                                                        *
**      When linking your C modules with the library, you automatically   *
**      link the object module, containing the C startup code. This       *
**      module is called cstart.obj and is present in every C library     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

extern void _init( void );
extern int   main( int argc );
extern void  exit( int );
#pragma weak    exit
#pragma extern  _Exit

extern  char    _lc_es[];                       /* system stack end label */

void __reset _start( void )
{
        __setsp((unsigned int)_lc_es-1);        /* initialize stack pointer */
        _init();                                /* initialize C variables */
        exit( main(0) );                        /* argc is 0 */
}
