/**************************************************************************
**                                                                        *
**  FILE        :  cos.c                                                  *
**                                                                        *
**  DESCRIPTION :  Source file for cos() routine                          *
**                 Computes the 'cosinus' for the given angle (in radians)*
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias   cosl    = _cos_spf
#pragma alias   cos             = _cos_spf
#endif
#pragma alias   cosf    = _cos_spf


extern float _sinusf( float, int );

static
float
_cos_spf( float arg )
{
        if( arg < 0.0f )
                arg = -arg;

        return( _sinusf( arg, 1 ) );
}


