/**************************************************************************
**                                                                        *
**  File:         clock.c                                                 * 
**                                                                        *
**  Version:       1.2                                                    *
**                                                                        *
**  Description :  Source file for clock() routine                        *
**                 This function will only work when using the            *
**                 XVW Pro Simulator as it uses the SFRs 0xfffc to 0xffff *
**                 to get the value of the state counter (equals the      *
**                 $CCNT variable in XVW).                                *
**                 The CCNT is fixed there by writing to address          *
**                 0xffff, after which it can be read.                    *
**                 If you want to use it in a real-time application       *
**                 you should rewrite the clock() function so it          *
**                 accesses the correct Timer SFRs.                       *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/


#include <time.h>

clock_t
clock( void )
{
        *(char __sfr volatile *)0xffff=0x0;      // trigger fix of CCNT
        return *(clock_t __sfr volatile *)0xfffc;
}
