/**************************************************************************
**                                                                        *
**  FILE        :  atanhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The atanh() function.                                  *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * atanh(x)
 *
 * Edwards
 *
 * ISO F.9.2.3 defines exceptions. These should be handled here,
 * but for now we rely on log and divide to do the right thing.
 */
extern  double          atanh(double x)
{
        if (x == 0.0)
        {
                return x;
        }
#if 0
        // x == 1 -> return infinity, raise divide-by-zero exception.
        // x == -1 -> return -infinity, raise divide-by-zero exception.
        // |x| > 1 -> return NaN, raise invalid FP exception.
#endif
        return log((1.0+x)/(1.0-x))/2.0;
}
