/**************************************************************************
**                                                                        *
**  FILE        :  atan2.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for atan2() routine                        *
**                 Computes the 'arctangent' for the given value          *
**                 (return value in radians)                              *
**                 argument in the range [-pi,pi].                        *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifndef __SINGLE_FP__
#pragma alias   atan2l  = _atan2_dpf
#pragma alias   atan2           = _atan2_dpf


#define PIO2    1.570796326794896619231e0
extern double _atan( double );

static
double
_atan2_dpf( double arg1, double arg2 )
{
        if( ( arg1 + arg2 ) == arg1 )
        {
                if( arg1 == 0.0 )
                        return( 0.0 );
                else if( arg1 > 0.0 )
                        return( PIO2 );
                else
                        return( -PIO2 );
        }
        else if( arg2 < 0.0 )
        {
                if( arg1 == 0.0 )
                        return( copysign( PIO2 + PIO2, arg1 ) );
                else if( arg1 > 0.0 )
                        return( PIO2 + PIO2 - _atan( -arg1 / arg2 ) );
                else
                        return( -PIO2 - PIO2 + _atan( arg1 / arg2 ) );
        }
        else if( arg1 > 0.0 )
        {
                return( _atan( arg1 / arg2 ) );
        }
        else
        {
                return( -_atan( -arg1 / arg2 ) );
        }
}

#endif

