/**************************************************************************
**                                                                        *
**  FILE        :  asin.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for asin() routine                         *
**                 Computes the 'arcsinus' of the given value.            *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>
#include        <errno.h>

#ifndef __SINGLE_FP__
#pragma alias   asinl   = _asin_dpf
#pragma alias   asin            = _asin_dpf


#define PIO2    1.570796326794896619231e0

static
double
_asin_dpf( double arg )
{
        int     negative;
        double  temp;

        negative = 0;

        if( arg < 0.0 )
        {
                arg = -arg;
                negative = 1;
        }
        
        if( arg > 1.0 )
        {
                errno = EDOM;
                return( 0.0 );
        }

        temp = sqrt( 1.0 - arg * arg );
        if( arg > 0.7 )
                temp = PIO2 - atan( temp / arg );
        else
                temp = atan( arg / temp );

        if( !negative )
                return( temp );
        else
                return( -temp );
}

#endif

