/**************************************************************************
**                                                                        *
**  FILE        :  acoshg.c                                               *
**                                                                        *
**  DESCRIPTION :  The acosh() function.                                  *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * acosh(x)
 *
 * Edwards
 *
 * ISO F.9.2.1 defines exceptions. These should be handled here,
 * but for now we rely on sqrt to do the right thing.
 */
extern  float           acoshf(float x)
{
        if (x == 1.0f)
        {
                return 0.0f;
        }
#if 0
        if (x < 1.0f)
        {
                // return NaN and raise invalid FP exception.
        }
        if (isinf(x))
        {
                return x;
        }
#endif
        return logf(x+sqrtf(x*x-1.0f));
}
