/**************************************************************************
**                                                                        *
**  FILE        :  inttypes.h                                             *
**                                                                        *
**  DESCRIPTION :  Format conversion of integer types                     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _INTTYPES_H
#define _INTTYPES_H

#include <stdint.h>

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef _WCHAR_T
typedef __wchar_t       wchar_t;
#define _WCHAR_T
#endif

typedef struct
{
        intmax_t        quot;
        intmax_t        rem;
}                       imaxdiv_t;

/*
 * 7.8.1 Macros for format specifiers
 */
#if ! defined __cplusplus || defined __STDC_FORMAT_MACROS

/* 2: fprintf macros for signed integers */
#define PRId8           "hhd"
#define PRId16          "hd"
#define PRId32          "ld"

#define PRIdLEAST8      "hhd"
#define PRIdLEAST16     "hd"
#define PRIdLEAST32     "ld"

#define PRIdFAST8       "hhd"
#define PRIdFAST16      "hd"
#define PRIdFAST32      "ld"

#define PRIdMAX         "ld"
#define PRIdPTR         PRId32

#define PRIi8           "hhi"
#define PRIi16          "hi"
#define PRIi32          "li"

#define PRIiLEAST8      "hhi"
#define PRIiLEAST16     "hi"
#define PRIiLEAST32     "li"

#define PRIiFAST8       "hhi"
#define PRIiFAST16      "hi"
#define PRIiFAST32      "li"

#define PRIiMAX         "li"
#define PRIiPTR         PRIi32

/* 3: fprintf macros for unsigned integers */
#define PRIo8           "hho"
#define PRIo16          "ho"
#define PRIo32          "lo"

#define PRIoLEAST8      "hho"
#define PRIoLEAST16     "ho"
#define PRIoLEAST32     "lo"

#define PRIoFAST8       "hho"
#define PRIoFAST16      "ho"
#define PRIoFAST32      "lo"

#define PRIoMAX         "lo"
#define PRIoPTR         PRIo32

#define PRIu8           "hhu"
#define PRIu16          "hu"
#define PRIu32          "lu"

#define PRIuLEAST8      "hhu"
#define PRIuLEAST16     "hu"
#define PRIuLEAST32     "lu"

#define PRIuFAST8       "hhu"
#define PRIuFAST16      "hu"
#define PRIuFAST32      "lu"

#define PRIuMAX         "lu"
#define PRIuPTR         PRIu32

#define PRIx8           "hhx"
#define PRIx16          "hx"
#define PRIx32          "lx"

#define PRIxLEAST8      "hhx"
#define PRIxLEAST16     "hx"
#define PRIxLEAST32     "lx"

#define PRIxFAST8       "hhx"
#define PRIxFAST16      "hx"
#define PRIxFAST32      "lx"

#define PRIxMAX         "lx"
#define PRIxPTR         PRIx32

#define PRIX8           "hhX"
#define PRIX16          "hX"
#define PRIX32          "lX"

#define PRIXLEAST8      "hhX"
#define PRIXLEAST16     "hX"
#define PRIXLEAST32     "lX"

#define PRIXFAST8       "hhX"
#define PRIXFAST16      "hX"
#define PRIXFAST32      "lX"

#define PRIXMAX         "lX"
#define PRIXPTR         PRIX32

/* 4: fscanf macros for signed integers */
#define SCNd8           "hhd"
#define SCNd16          "hd"
#define SCNd32          "ld"

#define SCNdLEAST8      "hhd"
#define SCNdLEAST16     "hd"
#define SCNdLEAST32     "ld"

#define SCNdFAST8       "hhd"
#define SCNdFAST16      "hd"
#define SCNdFAST32      "ld"

#define SCNdMAX         "ld"
#define SCNdPTR         SCNd32

#define SCNi8           "hhi"
#define SCNi16          "hi"
#define SCNi32          "li"

#define SCNiLEAST8      "hhi"
#define SCNiLEAST16     "hi"
#define SCNiLEAST32     "li"

#define SCNiFAST8       "hhi"
#define SCNiFAST16      "hi"
#define SCNiFAST32      "li"

#define SCNiMAX         "li"
#define SCNiPTR         SCNi32

/* 5: fscanf macros for unsigned integers */
#define SCNo8           "hho"
#define SCNo16          "ho"
#define SCNo32          "lo"

#define SCNoLEAST8      "hho"
#define SCNoLEAST16     "ho"
#define SCNoLEAST32     "lo"

#define SCNoFAST8       "hho"
#define SCNoFAST16      "ho"
#define SCNoFAST32      "lo"

#define SCNoMAX         "lo"
#define SCNoPTR         SCNo32

#define SCNu8           "hhu"
#define SCNu16          "hu"
#define SCNu32          "lu"

#define SCNuLEAST8      "hhu"
#define SCNuLEAST16     "hu"
#define SCNuLEAST32     "lu"

#define SCNuFAST8       "hhu"
#define SCNuFAST16      "hu"
#define SCNuFAST32      "lu"

#define SCNuMAX         "lu"
#define SCNuPTR         SCNu32

#define SCNx8           "hhx"
#define SCNx16          "hx"
#define SCNx32          "lx"

#define SCNxLEAST8      "hhx"
#define SCNxLEAST16     "hx"
#define SCNxLEAST32     "lx"

#define SCNxFAST8       "hhx"
#define SCNxFAST16      "hx"
#define SCNxFAST32      "lx"

#define SCNxMAX         "lx"
#define SCNxPTR         SCNx32

#endif

/*
 * 7.8.2 Functions for greatest-width integer types
 */
extern  intmax_t        imaxabs(intmax_t j);
extern  imaxdiv_t       imaxdiv(intmax_t numer, intmax_t denom);
extern  intmax_t        strtoimax(const char * restrict nptr, char ** restrict endptr, int base);
extern  uintmax_t       strtoumax(const char * restrict nptr, char ** restrict endptr, int base);
extern  intmax_t        wcstoimax(const wchar_t * restrict nptr, wchar_t ** restrict endptr, int base);
extern  uintmax_t       wcstoumax(const wchar_t * restrict nptr, wchar_t ** restrict endptr, int base);

#ifdef  __cplusplus
}
#endif  /* defined(__cplusplus) */

#endif  /* _INTTYPES_H */
