////////////////////////////////////////////////////////////////////////////
//
//  File        :  z80.lsl
//
//  Version	:  1.14
//
//  Description :  Linker script file for the Z80 architecture
//
//  Copyright 2003 Altium BV
//


////////////////////////////////////////////////////////////////////////////
//
// Some default values
//

#ifndef __STACK
#  define __STACK 8k
#endif
#ifndef __HEAP
#  define __HEAP 2k
#endif

#ifndef __HARVARD
#  ifndef __ROMSIZE
#    define __ROMSIZE 32k
#  endif
#  ifndef __RAMSIZE
#    define __RAMSIZE 64k-__ROMSIZE
#  endif
#else /* HARVARD */
#  ifndef __ROMSIZE
#    define __ROMSIZE 64k
#  endif
#  ifndef __RAMSIZE
#    define __RAMSIZE 64k
#  endif
#endif
#ifndef __SFRSIZE
# define __SFRSIZE 64k
#endif


architecture cz80
{
	endianness
	{
		little;
	}
	
	space data
	{
		id = 1;
		mau = 8;
		map (dest=bus:mem_bus, size=64k);
		
		stack "stack" 
		(
#ifdef __STACK_FIXED
			fixed,
#endif
			min_size = (__STACK) 
		);
		heap "heap" 
		(
#ifdef __HEAP_FIXED
			fixed,
#endif
			min_size = (__HEAP) 
		);

		section_layout
		{
                       "__lc_bs" := "__lc_ub_stack";
#ifdef __STACKADDR
			group (run_addr=__STACKADDR, ordered, contiguous ) select "stack";
#endif
#ifdef __HEAPADDR
			group (run_addr=__HEAPADDR,  ordered, contiguous ) select "heap";
#endif
 		}

 
		copytable;
		
		section_layout
		{
                        "__lc_bh" := "__lc_ub_heap";
                        "__lc_eh" := "__lc_ue_heap";
			"__lc_es" := "__lc_ue_stack";
			"__lc_cp" := "__lc_ub_table";

#ifdef __HEAPADDR
			group ( ordered, contiguous )
			{
				group (run_addr=__HEAPADDR) select "heap";
			}
#endif
		}
	}
	
	space code
	{
		id = 2;
		mau = 8;
#ifndef __HARVARD	
		map (dest=bus:mem_bus, size=64k);
#else /* __HARVARD */
		map (dest=bus:code_bus, size=64k);
#endif /* __HARVARD */

		start_address
		(
			symbol = "__start"
		);

//		section_layout
//		{
//			"__lc_cp" := "__lc_ub_table";
//		}
	}
	
	space sfr
	{
		id = 3;
		mau = 8;
		map (dest=bus:sfr_bus, size=64k);
	}	

	bus mem_bus
	{
		mau = 8;
		width = 16;
	}

	bus sfr_bus
	{
		mau = 8;
		width = 16;
	}

#ifdef __HARVARD
	bus code_bus
	{
		mau = 8;
		width = 16;
	}
#endif  /* __HARVARD */
}

////////////////////////////////////////////////////////////////////////////
//
// If no memory is defined yet use the following memory settings
//
#ifndef __MEMORY

#ifndef __HARVARD
memory xrom
{
    mau = 8;
    type = rom;
    size = __ROMSIZE;
    map ( dest=bus:cz80:mem_bus, src_offset=0x0, dest_offset=0x0, size=__ROMSIZE );
}
memory xram
{
    mau = 8;
    type = ram;
    size = __RAMSIZE;
    map ( dest=bus:cz80:mem_bus, src_offset=0, dest_offset=__ROMSIZE, size=__RAMSIZE );
}

#else /* __HARVARD */

memory xram
{
    mau = 8;
    type = ram;
    size = __RAMSIZE;
    map ( dest=bus:cz80:mem_bus, src_offset=0x0, dest_offset=0x0, size=__RAMSIZE );
}
memory xrom
{
    mau = 8;
    type = rom;
    size = __ROMSIZE;
    map ( dest=bus:cz80:code_bus, src_offset=0x0, dest_offset=0x0, size=__ROMSIZE );
}
#endif /* __HARVARD */

memory sfr
{
    mau = 8;
    type = ram;
    size = __SFRSIZE;
    map ( dest=bus:cz80:sfr_bus, src_offset=0x0, dest_offset=0x0, size=__SFRSIZE );
}
#endif /* __MEMORY */
