
/**************************************************************************
**                                                                        *
**  FILE        :  wprintf.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wprintf() routine.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int wprintf( const wchar_t* restrict format, ... )
{
        va_list         ap;
        int             chars;
        struct _io      io;

        va_start( ap, format );
        io.fp = stdout;
        chars = _dowprint( &io, format, ap );
        va_end( ap );
        return (ferror(stdout) ? EOF : chars);
}

#endif
