
/**************************************************************************
**                                                                        *
**  FILE        :  wmemmov.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wmemmove routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Copy n wide characters from the object pointed to by s2 to the object
 * pointed to by s1. Checks for memory overlapping.
 *
 * Return the value of s1.
 */
wchar_t*
wmemmove( wchar_t* s1, const wchar_t* s2, size_t n )
{
        wchar_t* dst;

        if ( s1 < s2 )
        {
                /* Start copying beginning with first wide character.
                 */
                for ( dst = s1; n > 0; n--, dst++, s2++ )
                {
                        *dst = *s2;
                }
        }
        else
        {
                /* Start copying beginning with last wide character.
                 */
                for ( dst = s1 + n - 1, s2 += (n - 1); n > 0; n--, dst--, s2-- )
                {
                        *dst = *s2;
                }
        }

        return s1;
}

#endif
